/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.transform;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.impl.ingredients.transform.serializer.TransformDamageSerializer;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import net.minecraft.item.ItemStack;

public class TransformDamage<T extends IIngredient>
implements IIngredientTransformer<T> {
    private final int amount;

    public TransformDamage(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public IItemStack transform(IItemStack stack) {
        ItemStack internal = stack.getImmutableInternal();
        int newDamage = internal.func_77952_i() + this.amount;
        if (internal.func_77958_k() < newDamage) {
            return MCItemStack.EMPTY.get();
        }
        internal.func_196085_b(newDamage);
        return new MCItemStack(internal.func_77946_l());
    }

    @Override
    public String getCommandString(T transformedIngredient) {
        if (this.amount == 1) {
            return transformedIngredient.getCommandString() + ".transformDamage()";
        }
        return String.format("%s.transformDamage(%s)", transformedIngredient.getCommandString(), this.amount);
    }

    @Override
    public IIngredientTransformerSerializer getSerializer() {
        return TransformDamageSerializer.INSTANCE;
    }
}

